/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.naming;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.wildfly.clustering.context.ContextualExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class NamespaceContextExecutor
implements ContextualExecutor {
    private final NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();

    public void execute(Runnable runner) {
        if (this.selector != null) {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
        }
        try {
            runner.run();
        }
        finally {
            if (this.selector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    public <E extends Exception> void execute(ExceptionRunnable<E> runner) throws E {
        if (this.selector != null) {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
        }
        try {
            runner.run();
        }
        finally {
            if (this.selector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    public <T> T execute(Callable<T> caller) throws Exception {
        if (this.selector != null) {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
        }
        try {
            T t = caller.call();
            return t;
        }
        finally {
            if (this.selector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    public <T> T execute(Supplier<T> supplier) {
        if (this.selector != null) {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (this.selector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    public <T, E extends Exception> T execute(ExceptionSupplier<T, E> supplier) throws E {
        if (this.selector != null) {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
        }
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (this.selector != null) {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    public Runnable contextualize(Runnable runner) {
        return this.selector != null ? super.contextualize(runner) : runner;
    }

    public <E extends Exception> ExceptionRunnable<E> contextualize(ExceptionRunnable<E> runner) {
        return this.selector != null ? super.contextualize(runner) : runner;
    }

    public <T> Callable<T> contextualize(Callable<T> caller) {
        return this.selector != null ? super.contextualize(caller) : caller;
    }

    public <T> Supplier<T> contextualize(Supplier<T> supplier) {
        return this.selector != null ? super.contextualize(supplier) : supplier;
    }

    public <T, E extends Exception> ExceptionSupplier<T, E> contextualize(ExceptionSupplier<T, E> supplier) {
        return this.selector != null ? super.contextualize(supplier) : supplier;
    }
}

