/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitEvolution<T>
implements EvolutionaryOperator<T> {
    private final EvolutionaryOperator<T> operator1;
    private final EvolutionaryOperator<T> operator2;
    private final NumberGenerator<Double> weightVariable;

    public SplitEvolution(EvolutionaryOperator<T> operator1, EvolutionaryOperator<T> operator2, double weight) {
        this(operator1, operator2, (NumberGenerator<Double>)new ConstantGenerator((Number)weight));
        if (weight <= 0.0 || weight >= 1.0) {
            throw new IllegalArgumentException("Split ratio must be greater than 0 and less than 1.");
        }
    }

    public SplitEvolution(EvolutionaryOperator<T> operator1, EvolutionaryOperator<T> operator2, NumberGenerator<Double> weightVariable) {
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.weightVariable = weightVariable;
    }

    @Override
    public List<T> apply(List<T> selectedCandidates, Random rng) {
        double ratio = (Double)this.weightVariable.nextValue();
        int size = (int)Math.round(ratio * (double)selectedCandidates.size());
        ArrayList<T> selectionClone = new ArrayList<T>(selectedCandidates);
        Collections.shuffle(selectionClone, rng);
        List list1 = selectionClone.subList(0, size);
        List list2 = selectionClone.subList(size, selectedCandidates.size());
        ArrayList<T> result = new ArrayList<T>(selectedCandidates.size());
        result.addAll(this.operator1.apply(list1, rng));
        result.addAll(this.operator2.apply(list2, rng));
        return result;
    }
}

