/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeanWrapperImpl;
import org.springmodules.cache.util.SemicolonSeparatedPropertiesParser;

public class ReflectionCacheModelEditor
extends PropertyEditorSupport {
    private Class cacheModelClass;
    private Map cacheModelPropertyEditors;

    public final Class getCacheModelClass() {
        return this.cacheModelClass;
    }

    public final Map getCacheModelPropertyEditors() {
        return this.cacheModelPropertyEditors;
    }

    public final void setAsText(String text) {
        if (this.cacheModelClass == null) {
            throw new IllegalStateException("cacheModelClass should not be null");
        }
        Properties properties = SemicolonSeparatedPropertiesParser.parseProperties(text);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(this.cacheModelClass);
        if (properties != null) {
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String propertyName = (String)i.next();
                String textProperty = properties.getProperty(propertyName);
                Object propertyValue = null;
                PropertyEditor propertyEditor = this.getPropertyEditor(propertyName);
                if (propertyEditor != null) {
                    propertyEditor.setAsText(textProperty);
                    propertyValue = propertyEditor.getValue();
                } else {
                    propertyValue = textProperty;
                }
                beanWrapper.setPropertyValue(propertyName, propertyValue);
            }
        }
        this.setValue(beanWrapper.getWrappedInstance());
    }

    public final void setCacheModelClass(Class newCacheModelClass) {
        this.cacheModelClass = newCacheModelClass;
    }

    public final void setCacheModelPropertyEditors(Map newCacheModelPropertyEditors) {
        this.cacheModelPropertyEditors = newCacheModelPropertyEditors;
    }

    private PropertyEditor getPropertyEditor(String propertyName) {
        return this.cacheModelPropertyEditors == null ? null : (PropertyEditor)this.cacheModelPropertyEditors.get(propertyName);
    }
}

