/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.metadata.Attributes;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.interceptor.caching.AbstractCachingInterceptor;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;
import org.springmodules.cache.interceptor.caching.MetadataCachingAttributeSource;

public class MetadataCachingInterceptor
extends AbstractCachingInterceptor {
    private CachingAttributeSource cachingAttributeSource;

    public final CachingAttributeSource getCachingAttributeSource() {
        return this.cachingAttributeSource;
    }

    public final void setAttributes(Attributes attributes) {
        MetadataCachingAttributeSource source = new MetadataCachingAttributeSource();
        source.setAttributes(attributes);
        this.setCachingAttributeSource(source);
    }

    public final void setCachingAttributeSource(CachingAttributeSource s) {
        this.cachingAttributeSource = s;
    }

    protected Cached getCachingAttribute(MethodInvocation methodInvocation) {
        Object thisObject = methodInvocation.getThis();
        Class<?> targetClass = thisObject != null ? thisObject.getClass() : null;
        Method method = methodInvocation.getMethod();
        Cached attribute = this.cachingAttributeSource.attribute(method, targetClass);
        return attribute;
    }

    protected final CachingModel model(MethodInvocation methodInvocation) {
        Cached attribute = this.getCachingAttribute(methodInvocation);
        if (attribute == null) {
            return null;
        }
        String modelId = attribute.getModelId();
        if (!StringUtils.hasText((String)modelId)) {
            return null;
        }
        return (CachingModel)this.models().get(modelId);
    }
}

