/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.client.HttpStatusCodeException;

public class HttpClientErrorException
extends HttpStatusCodeException {
    private static final long serialVersionUID = 5177019431887513952L;

    public HttpClientErrorException(HttpStatusCode statusCode) {
        super(statusCode);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, byte @Nullable [] body2, @Nullable Charset responseCharset) {
        super(statusCode, statusText, body2, responseCharset);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset responseCharset) {
        super(statusCode, statusText, headers, body2, responseCharset);
    }

    public HttpClientErrorException(String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset responseCharset) {
        super(message, statusCode, statusText, headers, body2, responseCharset);
    }

    public static HttpClientErrorException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
        return HttpClientErrorException.create(null, statusCode, statusText, headers, body2, charset);
    }

    public static HttpClientErrorException create(@Nullable String message, HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return switch (status) {
                case HttpStatus.BAD_REQUEST -> {
                    if (message != null) {
                        yield new BadRequest(message, statusText, headers, body2, charset);
                    }
                    yield new BadRequest(statusText, headers, body2, charset);
                }
                case HttpStatus.UNAUTHORIZED -> {
                    if (message != null) {
                        yield new Unauthorized(message, statusText, headers, body2, charset);
                    }
                    yield new Unauthorized(statusText, headers, body2, charset);
                }
                case HttpStatus.FORBIDDEN -> {
                    if (message != null) {
                        yield new Forbidden(message, statusText, headers, body2, charset);
                    }
                    yield new Forbidden(statusText, headers, body2, charset);
                }
                case HttpStatus.NOT_FOUND -> {
                    if (message != null) {
                        yield new NotFound(message, statusText, headers, body2, charset);
                    }
                    yield new NotFound(statusText, headers, body2, charset);
                }
                case HttpStatus.METHOD_NOT_ALLOWED -> {
                    if (message != null) {
                        yield new MethodNotAllowed(message, statusText, headers, body2, charset);
                    }
                    yield new MethodNotAllowed(statusText, headers, body2, charset);
                }
                case HttpStatus.NOT_ACCEPTABLE -> {
                    if (message != null) {
                        yield new NotAcceptable(message, statusText, headers, body2, charset);
                    }
                    yield new NotAcceptable(statusText, headers, body2, charset);
                }
                case HttpStatus.CONFLICT -> {
                    if (message != null) {
                        yield new Conflict(message, statusText, headers, body2, charset);
                    }
                    yield new Conflict(statusText, headers, body2, charset);
                }
                case HttpStatus.GONE -> {
                    if (message != null) {
                        yield new Gone(message, statusText, headers, body2, charset);
                    }
                    yield new Gone(statusText, headers, body2, charset);
                }
                case HttpStatus.UNSUPPORTED_MEDIA_TYPE -> {
                    if (message != null) {
                        yield new UnsupportedMediaType(message, statusText, headers, body2, charset);
                    }
                    yield new UnsupportedMediaType(statusText, headers, body2, charset);
                }
                case HttpStatus.TOO_MANY_REQUESTS -> {
                    if (message != null) {
                        yield new TooManyRequests(message, statusText, headers, body2, charset);
                    }
                    yield new TooManyRequests(statusText, headers, body2, charset);
                }
                case HttpStatus.UNPROCESSABLE_ENTITY -> {
                    if (message != null) {
                        yield new UnprocessableEntity(message, statusText, headers, body2, charset);
                    }
                    yield new UnprocessableEntity(statusText, headers, body2, charset);
                }
                case HttpStatus.UNPROCESSABLE_CONTENT -> {
                    if (message != null) {
                        yield new UnprocessableContent(message, statusText, headers, body2, charset);
                    }
                    yield new UnprocessableContent(statusText, headers, body2, charset);
                }
                default -> message != null ? new HttpClientErrorException(message, statusCode, statusText, headers, body2, charset) : new HttpClientErrorException(statusCode, statusText, headers, body2, charset);
            };
        }
        if (message != null) {
            return new HttpClientErrorException(message, statusCode, statusText, headers, body2, charset);
        }
        return new HttpClientErrorException(statusCode, statusText, headers, body2, charset);
    }

    public static final class BadRequest
    extends HttpClientErrorException {
        private BadRequest(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.BAD_REQUEST, statusText, headers, body2, charset);
        }

        private BadRequest(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.BAD_REQUEST, statusText, headers, body2, charset);
        }
    }

    public static final class Unauthorized
    extends HttpClientErrorException {
        private Unauthorized(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.UNAUTHORIZED, statusText, headers, body2, charset);
        }

        private Unauthorized(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.UNAUTHORIZED, statusText, headers, body2, charset);
        }
    }

    public static final class Forbidden
    extends HttpClientErrorException {
        private Forbidden(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.FORBIDDEN, statusText, headers, body2, charset);
        }

        private Forbidden(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.FORBIDDEN, statusText, headers, body2, charset);
        }
    }

    public static final class NotFound
    extends HttpClientErrorException {
        private NotFound(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.NOT_FOUND, statusText, headers, body2, charset);
        }

        private NotFound(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_FOUND, statusText, headers, body2, charset);
        }
    }

    public static final class MethodNotAllowed
    extends HttpClientErrorException {
        private MethodNotAllowed(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.METHOD_NOT_ALLOWED, statusText, headers, body2, charset);
        }

        private MethodNotAllowed(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.METHOD_NOT_ALLOWED, statusText, headers, body2, charset);
        }
    }

    public static final class NotAcceptable
    extends HttpClientErrorException {
        private NotAcceptable(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.NOT_ACCEPTABLE, statusText, headers, body2, charset);
        }

        private NotAcceptable(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_ACCEPTABLE, statusText, headers, body2, charset);
        }
    }

    public static final class Conflict
    extends HttpClientErrorException {
        private Conflict(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.CONFLICT, statusText, headers, body2, charset);
        }

        private Conflict(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.CONFLICT, statusText, headers, body2, charset);
        }
    }

    public static final class Gone
    extends HttpClientErrorException {
        private Gone(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.GONE, statusText, headers, body2, charset);
        }

        private Gone(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.GONE, statusText, headers, body2, charset);
        }
    }

    public static final class UnsupportedMediaType
    extends HttpClientErrorException {
        private UnsupportedMediaType(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.UNSUPPORTED_MEDIA_TYPE, statusText, headers, body2, charset);
        }

        private UnsupportedMediaType(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.UNSUPPORTED_MEDIA_TYPE, statusText, headers, body2, charset);
        }
    }

    public static final class TooManyRequests
    extends HttpClientErrorException {
        private TooManyRequests(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.TOO_MANY_REQUESTS, statusText, headers, body2, charset);
        }

        private TooManyRequests(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.TOO_MANY_REQUESTS, statusText, headers, body2, charset);
        }
    }

    @Deprecated(since="7.0")
    public static final class UnprocessableEntity
    extends HttpClientErrorException {
        private UnprocessableEntity(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.UNPROCESSABLE_ENTITY, statusText, headers, body2, charset);
        }

        private UnprocessableEntity(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.UNPROCESSABLE_ENTITY, statusText, headers, body2, charset);
        }
    }

    public static final class UnprocessableContent
    extends HttpClientErrorException {
        private UnprocessableContent(String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(HttpStatus.UNPROCESSABLE_CONTENT, statusText, headers, body2, charset);
        }

        private UnprocessableContent(String message, String statusText, HttpHeaders headers, byte @Nullable [] body2, @Nullable Charset charset) {
            super(message, HttpStatus.UNPROCESSABLE_CONTENT, statusText, headers, body2, charset);
        }
    }
}

