/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebConnection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.DelegatingWebConnection;
import org.springframework.test.web.servlet.htmlunit.HostRequestMatcher;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnection;
import org.springframework.test.web.servlet.htmlunit.WebRequestMatcher;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public abstract class MockMvcWebConnectionBuilderSupport<T extends MockMvcWebConnectionBuilderSupport<T>> {
    private final MockMvc mockMvc;
    private final List<WebRequestMatcher> mockMvcRequestMatchers = new ArrayList<WebRequestMatcher>();
    private String contextPath = "";
    private boolean alwaysUseMockMvc;

    protected MockMvcWebConnectionBuilderSupport(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, (String)"mockMvc must not be null");
        this.mockMvc = mockMvc;
        this.mockMvcRequestMatchers.add(new HostRequestMatcher("localhost"));
    }

    protected MockMvcWebConnectionBuilderSupport(WebApplicationContext context) {
        this(MockMvcBuilders.webAppContextSetup(context).build());
    }

    protected MockMvcWebConnectionBuilderSupport(WebApplicationContext context, MockMvcConfigurer configurer) {
        this(((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup(context).apply(configurer)).build());
    }

    public T contextPath(String contextPath) {
        this.contextPath = contextPath;
        return (T)this;
    }

    public T alwaysUseMockMvc() {
        this.alwaysUseMockMvc = true;
        return (T)this;
    }

    public T useMockMvc(WebRequestMatcher ... matchers) {
        for (WebRequestMatcher matcher : matchers) {
            this.mockMvcRequestMatchers.add(matcher);
        }
        return (T)this;
    }

    public T useMockMvcForHosts(String ... hosts) {
        this.mockMvcRequestMatchers.add(new HostRequestMatcher(hosts));
        return (T)this;
    }

    protected final WebConnection createConnection(WebConnection defaultConnection) {
        Assert.notNull((Object)defaultConnection, (String)"defaultConnection must not be null");
        MockMvcWebConnection mockMvcWebConnection = new MockMvcWebConnection(this.mockMvc, this.contextPath);
        if (this.alwaysUseMockMvc) {
            return mockMvcWebConnection;
        }
        ArrayList<DelegatingWebConnection.DelegateWebConnection> delegates = new ArrayList<DelegatingWebConnection.DelegateWebConnection>(this.mockMvcRequestMatchers.size());
        for (WebRequestMatcher matcher : this.mockMvcRequestMatchers) {
            delegates.add(new DelegatingWebConnection.DelegateWebConnection(matcher, mockMvcWebConnection));
        }
        return new DelegatingWebConnection(defaultConnection, delegates);
    }
}

