/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.GenericXmlContextLoader;
import org.springframework.util.StringUtils;

public class GenericGroovyXmlContextLoader
extends GenericXmlContextLoader {
    @Override
    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        GroovyBeanDefinitionReader groovyReader = new GroovyBeanDefinitionReader((BeanDefinitionRegistry)context);
        for (String location : mergedConfig.getLocations()) {
            if (StringUtils.endsWithIgnoreCase((String)location, (String)".xml")) {
                xmlReader.loadBeanDefinitions(location);
                continue;
            }
            groovyReader.loadBeanDefinitions(location);
        }
    }

    @Override
    protected String[] getResourceSuffixes() {
        return new String[]{super.getResourceSuffix(), "Context.groovy"};
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("GenericGroovyXmlContextLoader does not support the getResourceSuffix() method");
    }
}

