/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.ClassUtils;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();

    MockMultipartHttpServletRequestBuilder(String urlTemplate, Object ... urlVariables) {
        super(HttpMethod.POST, urlTemplate, urlVariables);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof MockMultipartHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        super.merge(parent);
        MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
        this.files.addAll(parentBuilder.files);
        return this;
    }

    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request = servlet3Present ? this.createServlet3Request() : new MockMultipartHttpServletRequest();
        for (MockMultipartFile file : this.files) {
            request.addFile(file);
        }
        return request;
    }

    private MockMultipartHttpServletRequest createServlet3Request() {
        try {
            String className = "org.springframework.test.web.servlet.request.Servlet3MockMultipartHttpServletRequest";
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)MockMultipartHttpServletRequestBuilder.class.getClassLoader());
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (MockMultipartHttpServletRequest)BeanUtils.instantiateClass(constructor, (Object[])new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to instantiate MockHttpServletRequest", t);
        }
    }
}

