/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.text.SimpleDateFormat;
import java.util.List;
import org.springframework.social.twitter.api.SavedSearch;
import org.springframework.social.twitter.api.SearchOperations;
import org.springframework.social.twitter.api.SearchResults;
import org.springframework.social.twitter.api.Trends;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.LocalTrendsHolder;
import org.springframework.social.twitter.api.impl.SavedSearchList;
import org.springframework.social.twitter.api.impl.SearchParameters;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchTemplate
extends AbstractTwitterOperations
implements SearchOperations {
    private final RestTemplate restTemplate;
    static final int DEFAULT_RESULTS_PER_PAGE = 50;

    public SearchTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public SearchResults search(String query) {
        return this.search(new SearchParameters(query));
    }

    @Override
    public SearchResults search(String query, int resultsPerPage) {
        SearchParameters p = new SearchParameters(query);
        p.setCount(resultsPerPage);
        return this.search(p);
    }

    @Override
    public SearchResults search(String query, int resultsPerPage, long sinceId, long maxId) {
        SearchParameters p = new SearchParameters(query);
        p.setCount(resultsPerPage);
        p.setSinceId(sinceId);
        p.setMaxId(maxId);
        return this.search(p);
    }

    @Override
    public SearchResults search(SearchParameters searchParameters) {
        this.requireAuthorization();
        Assert.notNull((Object)searchParameters);
        MultiValueMap<String, String> parameters = this.buildQueryParametersFromSearchParameters(searchParameters);
        return (SearchResults)this.restTemplate.getForObject(this.buildUri("search/tweets.json", parameters), SearchResults.class);
    }

    @Override
    public List<SavedSearch> getSavedSearches() {
        this.requireAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("saved_searches/list.json"), SavedSearchList.class);
    }

    @Override
    public SavedSearch getSavedSearch(long searchId) {
        this.requireAuthorization();
        return (SavedSearch)this.restTemplate.getForObject(this.buildUri("saved_searches/show/" + searchId + ".json"), SavedSearch.class);
    }

    @Override
    public SavedSearch createSavedSearch(String query) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"query", (Object)query);
        return (SavedSearch)this.restTemplate.postForObject(this.buildUri("saved_searches/create.json"), (Object)data, SavedSearch.class);
    }

    @Override
    public void deleteSavedSearch(long searchId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("saved_searches/destroy/" + searchId + ".json"));
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId) {
        return this.getLocalTrends(whereOnEarthId, false);
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId, boolean excludeHashtags) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"id", (Object)String.valueOf(whereOnEarthId));
        if (excludeHashtags) {
            parameters.set((Object)"exclude", (Object)"hashtags");
        }
        return ((LocalTrendsHolder)this.restTemplate.getForObject(this.buildUri("trends/place.json", (MultiValueMap<String, String>)parameters), LocalTrendsHolder.class)).getTrends();
    }

    private MultiValueMap<String, String> buildQueryParametersFromSearchParameters(SearchParameters searchParameters) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"q", (Object)searchParameters.getQuery());
        if (searchParameters.getGeoCode() != null) {
            parameters.set((Object)"geocode", (Object)searchParameters.getGeoCode().toString());
        }
        if (searchParameters.getLang() != null) {
            parameters.set((Object)"lang", (Object)searchParameters.getLang());
        }
        if (searchParameters.getLocale() != null) {
            parameters.set((Object)"locale", (Object)searchParameters.getLocale());
        }
        if (searchParameters.getResultType() != null) {
            parameters.set((Object)"result_type", (Object)searchParameters.getResultType().toString());
        }
        parameters.set((Object)"count", (Object)(searchParameters.getCount() != null ? String.valueOf(searchParameters.getCount()) : String.valueOf(50)));
        if (searchParameters.getUntil() != null) {
            parameters.set((Object)"until", (Object)new SimpleDateFormat("yyyy-MM-dd").format(searchParameters.getUntil()));
        }
        if (searchParameters.getSinceId() != null) {
            parameters.set((Object)"since_id", (Object)String.valueOf(searchParameters.getSinceId()));
        }
        if (searchParameters.getMaxId() != null) {
            parameters.set((Object)"max_id", (Object)String.valueOf(searchParameters.getMaxId()));
        }
        if (!searchParameters.isIncludeEntities()) {
            parameters.set((Object)"include_entities", (Object)"false");
        }
        return parameters;
    }
}

