/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import org.springframework.social.twitter.api.DirectMessage;
import org.springframework.social.twitter.api.DirectMessageOperations;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.DirectMessageList;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectMessageTemplate
extends AbstractTwitterOperations
implements DirectMessageOperations {
    private final RestTemplate restTemplate;

    public DirectMessageTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<DirectMessage> getDirectMessagesReceived() {
        return this.getDirectMessagesReceived(1, 20, 0L, 0L);
    }

    @Override
    public List<DirectMessage> getDirectMessagesReceived(int page, int pageSize) {
        return this.getDirectMessagesReceived(page, pageSize, 0L, 0L);
    }

    @Override
    public List<DirectMessage> getDirectMessagesReceived(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("direct_messages.json", parameters), DirectMessageList.class);
    }

    @Override
    public List<DirectMessage> getDirectMessagesSent() {
        return this.getDirectMessagesSent(1, 20, 0L, 0L);
    }

    @Override
    public List<DirectMessage> getDirectMessagesSent(int page, int pageSize) {
        return this.getDirectMessagesSent(page, pageSize, 0L, 0L);
    }

    @Override
    public List<DirectMessage> getDirectMessagesSent(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("direct_messages/sent.json", parameters), DirectMessageList.class);
    }

    @Override
    public DirectMessage getDirectMessage(long id) {
        this.requireAuthorization();
        return (DirectMessage)this.restTemplate.getForObject(this.buildUri("direct_messages/show.json", "id", String.valueOf(id)), DirectMessage.class);
    }

    @Override
    public DirectMessage sendDirectMessage(String toScreenName, String text) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"screen_name", (Object)String.valueOf(toScreenName));
        data.add((Object)"text", (Object)text);
        return (DirectMessage)this.restTemplate.postForObject(this.buildUri("direct_messages/new.json"), (Object)data, DirectMessage.class);
    }

    @Override
    public DirectMessage sendDirectMessage(long toUserId, String text) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"user_id", (Object)String.valueOf(toUserId));
        data.add((Object)"text", (Object)text);
        return (DirectMessage)this.restTemplate.postForObject(this.buildUri("direct_messages/new.json"), (Object)data, DirectMessage.class);
    }

    @Override
    public void deleteDirectMessage(long messageId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("direct_messages/destroy.json", "id", String.valueOf(messageId)));
    }
}

