/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Group;
import org.springframework.social.facebook.api.GroupMemberReference;
import org.springframework.social.facebook.api.GroupMembership;
import org.springframework.social.facebook.api.GroupOperations;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.User;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupTemplate
implements GroupOperations {
    private final GraphApi graphApi;
    private static final String[] FULL_PROFILE_FIELDS = new String[]{"id", "name", "first_name", "last_name", "gender", "locale", "education", "work", "email", "third_party_id", "link", "timezone", "updated_time", "verified", "about", "bio", "birthday", "location", "hometown", "interested_in", "religion", "political", "quotes", "relationship_status", "significant_other", "website"};

    public GroupTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public Group getGroup(String groupId) {
        return this.graphApi.fetchObject(groupId, Group.class);
    }

    @Override
    public byte[] getGroupImage(String groupId) {
        return this.getGroupImage(groupId, ImageType.NORMAL);
    }

    @Override
    public byte[] getGroupImage(String groupId, ImageType imageType) {
        return this.graphApi.fetchImage(groupId, "picture", imageType);
    }

    @Override
    public PagedList<GroupMemberReference> getMembers(String groupId) {
        return this.graphApi.fetchConnections(groupId, "members", GroupMemberReference.class, new String[0]);
    }

    @Override
    public PagedList<User> getMemberProfiles(String groupId) {
        return this.graphApi.fetchConnections(groupId, "members", User.class, FULL_PROFILE_FIELDS);
    }

    @Override
    public PagedList<GroupMembership> getMemberships() {
        return this.getMemberships("me");
    }

    @Override
    public PagedList<GroupMembership> getMemberships(String userId) {
        return this.graphApi.fetchConnections(userId, "groups", GroupMembership.class, new String[0]);
    }

    @Override
    public PagedList<Group> search(String query) {
        return this.search(query, new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Group> search(String query, PagingParameters pagedListParameters) {
        MultiValueMap<String, String> queryMap = PagedListUtils.getPagingParameters(pagedListParameters);
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"group");
        queryMap.add((Object)"fields", (Object)"owner,name,description,privacy,icon,updated_time,email");
        return this.graphApi.fetchConnections("search", "", Group.class, queryMap);
    }
}

