/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.Collection;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.util.Assert;

public final class JwtAudienceValidator
implements OAuth2TokenValidator<Jwt> {
    private final JwtClaimValidator<Collection<String>> validator;

    public JwtAudienceValidator(String audience) {
        Assert.notNull((Object)audience, (String)"audience cannot be null");
        this.validator = new JwtClaimValidator<Collection>("aud", claimValue -> claimValue != null && claimValue.contains(audience));
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        return this.validator.validate(token);
    }
}

