/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.web.server.logout;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class OidcClientInitiatedServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();
    private final RedirectServerLogoutSuccessHandler serverLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private String postLogoutRedirectUri;
    private Converter<RedirectUriParameters, Mono<String>> redirectUriResolver = new DefaultRedirectUriResolver();

    public OidcClientInitiatedServerLogoutSuccessHandler(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        return Mono.just((Object)authentication).filter(OAuth2AuthenticationToken.class::isInstance).filter(token -> authentication.getPrincipal() instanceof OidcUser).map(OAuth2AuthenticationToken.class::cast).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId).flatMap(this.clientRegistrationRepository::findByRegistrationId).flatMap(clientRegistration -> (Mono)this.redirectUriResolver.convert((Object)new RedirectUriParameters(exchange.getExchange(), authentication, (ClientRegistration)clientRegistration))).switchIfEmpty(this.serverLogoutSuccessHandler.onLogoutSuccess(exchange, authentication).then(Mono.empty())).flatMap(endpointUri -> this.redirectStrategy.sendRedirect(exchange.getExchange(), URI.create(endpointUri)));
    }

    private URI endSessionEndpoint(ClientRegistration clientRegistration) {
        Object endSessionEndpoint;
        if (clientRegistration != null && (endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint")) != null) {
            return URI.create(endSessionEndpoint.toString());
        }
        return null;
    }

    private String endpointUri(URI endSessionEndpoint, String idToken, String postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{idToken});
        if (postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    private String postLogoutRedirectUri(ServerHttpRequest request, ClientRegistration clientRegistration) {
        if (this.postLogoutRedirectUri == null) {
            return null;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).replacePath(request.getPath().contextPath().value()).replaceQuery(null).fragment(null).build();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        String path = uriComponents.getPath();
        uriVariables.put("basePath", path != null ? path : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        uriVariables.put("registrationId", clientRegistration.getRegistrationId());
        return UriComponentsBuilder.fromUriString((String)this.postLogoutRedirectUri).buildAndExpand(uriVariables).toUriString();
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void setLogoutSuccessUrl(URI logoutSuccessUrl) {
        Assert.notNull((Object)logoutSuccessUrl, (String)"logoutSuccessUrl cannot be null");
        this.serverLogoutSuccessHandler.setLogoutSuccessUrl(logoutSuccessUrl);
    }

    public void setRedirectUriResolver(Converter<RedirectUriParameters, Mono<String>> redirectUriResolver) {
        Assert.notNull(redirectUriResolver, (String)"redirectUriResolver cannot be null");
        this.redirectUriResolver = redirectUriResolver;
    }

    public void setRedirectStrategy(ServerRedirectStrategy redirectStrategy) {
        Assert.notNull((Object)redirectStrategy, (String)"redirectStrategy cannot be null");
        this.redirectStrategy = redirectStrategy;
    }

    private final class DefaultRedirectUriResolver
    implements Converter<RedirectUriParameters, Mono<String>> {
        private DefaultRedirectUriResolver() {
        }

        public Mono<String> convert(RedirectUriParameters redirectUriParameters) {
            return Mono.just((Object)redirectUriParameters.authentication).flatMap(authentication -> {
                URI endSessionEndpoint = OidcClientInitiatedServerLogoutSuccessHandler.this.endSessionEndpoint(redirectUriParameters.clientRegistration);
                if (endSessionEndpoint == null) {
                    return Mono.empty();
                }
                String idToken = OidcClientInitiatedServerLogoutSuccessHandler.this.idToken((Authentication)authentication);
                String postLogoutRedirectUri = OidcClientInitiatedServerLogoutSuccessHandler.this.postLogoutRedirectUri(redirectUriParameters.serverWebExchange.getRequest(), redirectUriParameters.clientRegistration);
                return Mono.just((Object)OidcClientInitiatedServerLogoutSuccessHandler.this.endpointUri(endSessionEndpoint, idToken, postLogoutRedirectUri));
            });
        }
    }

    public static final class RedirectUriParameters {
        private final ServerWebExchange serverWebExchange;
        private final Authentication authentication;
        private final ClientRegistration clientRegistration;

        public RedirectUriParameters(ServerWebExchange serverWebExchange, Authentication authentication, ClientRegistration clientRegistration) {
            Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
            Assert.notNull((Object)serverWebExchange, (String)"serverWebExchange cannot be null");
            Assert.notNull((Object)authentication, (String)"authentication cannot be null");
            this.serverWebExchange = serverWebExchange;
            this.authentication = authentication;
            this.clientRegistration = clientRegistration;
        }

        public ServerWebExchange getServerWebExchange() {
            return this.serverWebExchange;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public ClientRegistration getClientRegistration() {
            return this.clientRegistration;
        }
    }
}

