/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

@Configuration(proxyBeanMethods=false)
class SecurityReactorContextConfiguration {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    SecurityReactorContextConfiguration() {
    }

    @Bean
    SecurityReactorContextSubscriberRegistrar securityReactorContextSubscriberRegistrar() {
        SecurityReactorContextSubscriberRegistrar registrar = new SecurityReactorContextSubscriberRegistrar();
        registrar.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        return registrar;
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    static class SecurityReactorContextSubscriberRegistrar
    implements InitializingBean,
    DisposableBean {
        private static final String SECURITY_REACTOR_CONTEXT_OPERATOR_KEY = "org.springframework.security.SECURITY_REACTOR_CONTEXT_OPERATOR";
        private final Map<Object, Supplier<Object>> CONTEXT_ATTRIBUTE_VALUE_LOADERS = new HashMap<Object, Supplier<Object>>();
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

        SecurityReactorContextSubscriberRegistrar() {
            this.CONTEXT_ATTRIBUTE_VALUE_LOADERS.put(HttpServletRequest.class, SecurityReactorContextSubscriberRegistrar::getRequest);
            this.CONTEXT_ATTRIBUTE_VALUE_LOADERS.put(HttpServletResponse.class, SecurityReactorContextSubscriberRegistrar::getResponse);
            this.CONTEXT_ATTRIBUTE_VALUE_LOADERS.put(Authentication.class, this::getAuthentication);
        }

        public void afterPropertiesSet() throws Exception {
            Function lifter = Operators.liftPublisher((pub, sub) -> this.createSubscriberIfNecessary((CoreSubscriber)sub));
            Hooks.onLastOperator((String)SECURITY_REACTOR_CONTEXT_OPERATOR_KEY, lifter::apply);
        }

        public void destroy() throws Exception {
            Hooks.resetOnLastOperator((String)SECURITY_REACTOR_CONTEXT_OPERATOR_KEY);
        }

        void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        <T> CoreSubscriber<T> createSubscriberIfNecessary(CoreSubscriber<T> delegate) {
            if (delegate.currentContext().hasKey((Object)"org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES")) {
                return delegate;
            }
            return new SecurityReactorContextSubscriber<T>(delegate, this.getContextAttributes());
        }

        private Map<Object, Object> getContextAttributes() {
            return new LoadingMap<Object, Object>(this.CONTEXT_ATTRIBUTE_VALUE_LOADERS);
        }

        private static HttpServletRequest getRequest() {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes) {
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
                return servletRequestAttributes.getRequest();
            }
            return null;
        }

        private static HttpServletResponse getResponse() {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes) {
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
                return servletRequestAttributes.getResponse();
            }
            return null;
        }

        private Authentication getAuthentication() {
            return this.securityContextHolderStrategy.getContext().getAuthentication();
        }
    }

    static class LoadingMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> loaded = new ConcurrentHashMap();
        private final Map<K, Supplier<V>> loaders;

        LoadingMap(Map<K, Supplier<V>> loaders) {
            this.loaders = Collections.unmodifiableMap(new HashMap<K, Supplier<V>>(loaders));
        }

        @Override
        public int size() {
            return this.loaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.loaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.loaders.containsKey(key);
        }

        @Override
        public Set<K> keySet() {
            return this.loaders.keySet();
        }

        @Override
        public V get(Object key) {
            if (!this.loaders.containsKey(key)) {
                throw new IllegalArgumentException("This map only supports the following keys: " + String.valueOf(this.loaders.keySet()));
            }
            return (V)this.loaded.computeIfAbsent(key, k -> this.loaders.get(k).get());
        }

        @Override
        public V put(K key, V value) {
            if (!this.loaders.containsKey(key)) {
                throw new IllegalArgumentException("This map only supports the following keys: " + String.valueOf(this.loaders.keySet()));
            }
            return this.loaded.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (!this.loaders.containsKey(key)) {
                throw new IllegalArgumentException("This map only supports the following keys: " + String.valueOf(this.loaders.keySet()));
            }
            return this.loaded.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.loaded.clear();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.loaded.containsValue(value);
        }

        @Override
        public Collection<V> values() {
            return this.loaded.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.loaded.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoadingMap that = (LoadingMap)o;
            return this.loaded.equals(that.loaded);
        }

        @Override
        public int hashCode() {
            return this.loaded.hashCode();
        }
    }

    static class SecurityReactorContextSubscriber<T>
    implements CoreSubscriber<T> {
        static final String SECURITY_CONTEXT_ATTRIBUTES = "org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES";
        private final CoreSubscriber<T> delegate;
        private final Context context;

        SecurityReactorContextSubscriber(CoreSubscriber<T> delegate, Map<Object, Object> attributes) {
            Context context;
            this.delegate = delegate;
            this.context = context = this.getOrPutContext(attributes, this.delegate.currentContext());
        }

        private Context getOrPutContext(Map<Object, Object> attributes, Context currentContext) {
            if (currentContext.hasKey((Object)SECURITY_CONTEXT_ATTRIBUTES)) {
                return currentContext;
            }
            return currentContext.put((Object)SECURITY_CONTEXT_ATTRIBUTES, attributes);
        }

        public Context currentContext() {
            return this.context;
        }

        public void onSubscribe(Subscription s) {
            this.delegate.onSubscribe(s);
        }

        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        public void onError(Throwable ex) {
            this.delegate.onError(ex);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }
}

