/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class LogoutBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_LOGOUT_SUCCESS_URL = "logout-success-url";
    static final String DEF_LOGOUT_SUCCESS_URL = "/";
    static final String ATT_INVALIDATE_SESSION = "invalidate-session";
    static final String ATT_LOGOUT_URL = "logout-url";
    static final String DEF_LOGOUT_URL = "/j_spring_security_logout";
    static final String ATT_LOGOUT_HANDLER = "success-handler-ref";
    static final String ATT_DELETE_COOKIES = "delete-cookies";
    final String rememberMeServices;
    private ManagedList logoutHandlers = new ManagedList();

    public LogoutBeanDefinitionParser(String rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        String logoutUrl = null;
        String successHandlerRef = null;
        String logoutSuccessUrl = null;
        String invalidateSession = null;
        String deleteCookies = null;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(LogoutFilter.class);
        if (element != null) {
            Object source = pc.extractSource((Object)element);
            builder.getRawBeanDefinition().setSource(source);
            logoutUrl = element.getAttribute(ATT_LOGOUT_URL);
            successHandlerRef = element.getAttribute(ATT_LOGOUT_HANDLER);
            WebConfigUtils.validateHttpRedirect(logoutUrl, pc, source);
            logoutSuccessUrl = element.getAttribute(ATT_LOGOUT_SUCCESS_URL);
            WebConfigUtils.validateHttpRedirect(logoutSuccessUrl, pc, source);
            invalidateSession = element.getAttribute(ATT_INVALIDATE_SESSION);
            deleteCookies = element.getAttribute(ATT_DELETE_COOKIES);
        }
        if (!StringUtils.hasText(logoutUrl)) {
            logoutUrl = DEF_LOGOUT_URL;
        }
        builder.addPropertyValue("filterProcessesUrl", (Object)logoutUrl);
        if (StringUtils.hasText(successHandlerRef)) {
            if (StringUtils.hasText(logoutSuccessUrl)) {
                pc.getReaderContext().error("Use logout-success-url or success-handler-ref, but not both", pc.extractSource((Object)element));
            }
            builder.addConstructorArgReference(successHandlerRef);
        } else {
            if (!StringUtils.hasText(logoutSuccessUrl)) {
                logoutSuccessUrl = DEF_LOGOUT_SUCCESS_URL;
            }
            builder.addConstructorArgValue((Object)logoutSuccessUrl);
        }
        RootBeanDefinition sclh = new RootBeanDefinition(SecurityContextLogoutHandler.class);
        sclh.getPropertyValues().addPropertyValue("invalidateHttpSession", (Object)(!"false".equals(invalidateSession) ? 1 : 0));
        this.logoutHandlers.add((Object)sclh);
        if (this.rememberMeServices != null) {
            this.logoutHandlers.add((Object)new RuntimeBeanReference(this.rememberMeServices));
        }
        if (StringUtils.hasText((String)deleteCookies)) {
            RootBeanDefinition cookieDeleter = new RootBeanDefinition(CookieClearingLogoutHandler.class);
            String[] names = StringUtils.tokenizeToStringArray((String)deleteCookies, (String)",");
            cookieDeleter.getConstructorArgumentValues().addGenericArgumentValue((Object)names);
            this.logoutHandlers.add((Object)cookieDeleter);
        }
        builder.addConstructorArgValue((Object)this.logoutHandlers);
        return builder.getBeanDefinition();
    }

    ManagedList getLogoutHandlers() {
        return this.logoutHandlers;
    }
}

