/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.aot.NamedAotQuery;
import org.springframework.data.jpa.repository.aot.StringAotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.util.StringUtils;

record AotQueries(AotQuery result, AotQuery count) {
    public static AotQueries from(StringAotQuery query, @Nullable String countProjection, QueryEnhancerSelector selector) {
        return AotQueries.from(query, StringAotQuery::getQuery, countProjection, selector);
    }

    public static <T extends AotQuery> AotQueries from(T query, Function<T, DeclaredQuery> queryMapper, @Nullable String countProjection, QueryEnhancerSelector selector) {
        DeclaredQuery underlyingQuery = queryMapper.apply(query);
        QueryEnhancer queryEnhancer = selector.select(underlyingQuery).create(underlyingQuery);
        String derivedCountQuery = queryEnhancer.createCountQueryFor(StringUtils.hasText((String)countProjection) ? countProjection : null);
        DeclaredQuery countQuery = underlyingQuery.rewrite(derivedCountQuery);
        return new AotQueries(query, StringAotQuery.of(countQuery));
    }

    public static AotQueries from(AotQuery result, AotQuery count) {
        return new AotQueries(result, count);
    }

    public boolean isNative() {
        return this.result().isNative();
    }

    public QueryMetadata toMetadata(boolean paging) {
        return new AotQueryMetadata(paging);
    }

    private class AotQueryMetadata
    implements QueryMetadata {
        private final boolean paging;

        AotQueryMetadata(boolean paging) {
            this.paging = paging;
        }

        public Map<String, Object> serialize() {
            AotQuery aotQuery;
            LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
            AotQuery aotQuery2 = AotQueries.this.result();
            if (aotQuery2 instanceof NamedAotQuery) {
                NamedAotQuery nq = (NamedAotQuery)aotQuery2;
                serialized.put("name", nq.getName());
                serialized.put("query", nq.getQueryString());
            }
            if ((aotQuery = AotQueries.this.result()) instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)aotQuery;
                serialized.put("query", sq.getQueryString());
            }
            if (this.paging) {
                AotQuery aotQuery3;
                AotQuery aotQuery4 = AotQueries.this.count();
                if (aotQuery4 instanceof NamedAotQuery) {
                    NamedAotQuery nq = (NamedAotQuery)aotQuery4;
                    serialized.put("count-name", nq.getName());
                    serialized.put("count-query", nq.getQueryString());
                }
                if ((aotQuery3 = AotQueries.this.count()) instanceof StringAotQuery) {
                    StringAotQuery sq = (StringAotQuery)aotQuery3;
                    serialized.put("count-query", sq.getQueryString());
                }
            }
            return serialized;
        }
    }
}

