/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Entity;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultJpaEntityMetadata<T>
implements JpaEntityMetadata<T> {
    private final Class<T> domainType;

    public DefaultJpaEntityMetadata(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        this.domainType = domainType;
    }

    public Class<T> getJavaType() {
        return this.domainType;
    }

    @Override
    public String getEntityName() {
        Entity entity = (Entity)AnnotatedElementUtils.findMergedAnnotation(this.domainType, Entity.class);
        return null != entity && StringUtils.hasText((String)entity.name()) ? entity.name() : this.domainType.getSimpleName();
    }
}

