/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import javax.persistence.TemporalType;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.repository.Temporal;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;

public class JpaParameters
extends Parameters<JpaParameters, JpaParameter> {
    public JpaParameters(Method method) {
        super(method);
    }

    private JpaParameters(List<JpaParameter> parameters) {
        super(parameters);
    }

    protected JpaParameter createParameter(MethodParameter parameter) {
        return new JpaParameter(parameter);
    }

    protected JpaParameters createFrom(List<JpaParameter> parameters) {
        return new JpaParameters(parameters);
    }

    static class JpaParameter
    extends Parameter {
        private final Temporal annotation;
        private final boolean explicitlyNamed;
        private TemporalType temporalType;

        JpaParameter(MethodParameter parameter) {
            super(parameter);
            this.annotation = (Temporal)parameter.getParameterAnnotation(Temporal.class);
            this.explicitlyNamed = parameter.getParameterAnnotation(Param.class) != null;
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter!");
            }
        }

        public boolean isBindable() {
            return super.isBindable() || this.isTemporalParameter();
        }

        public boolean isTemporalParameter() {
            return this.isDateParameter() && this.hasTemporalParamAnnotation();
        }

        public TemporalType getTemporalType() {
            if (this.temporalType == null) {
                this.temporalType = this.annotation == null ? null : this.annotation.value();
            }
            return this.temporalType;
        }

        public boolean isExplicitlyNamed() {
            return this.explicitlyNamed;
        }

        private boolean hasTemporalParamAnnotation() {
            return this.annotation != null;
        }

        private boolean isDateParameter() {
            return this.getType().equals(Date.class);
        }
    }
}

