/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryComponentProvider;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public abstract class RepositoryConfigurationSourceSupport
implements RepositoryConfigurationSource {
    protected static final String DEFAULT_REPOSITORY_IMPL_POSTFIX = "Impl";
    private final Environment environment;

    public RepositoryConfigurationSourceSupport(Environment environment) {
        this.environment = environment == null ? new StandardEnvironment() : environment;
    }

    @Override
    public Collection<String> getCandidates(ResourceLoader loader) {
        RepositoryComponentProvider scanner = new RepositoryComponentProvider(this.getIncludeFilters());
        scanner.setResourceLoader(loader);
        scanner.setEnvironment(this.environment);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<String> result = new HashSet<String>();
        for (String basePackage : this.getBasePackages()) {
            Set components = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition definition : components) {
                result.add(definition.getBeanClassName());
            }
        }
        return result;
    }

    protected Iterable<TypeFilter> getExcludeFilters() {
        return Collections.emptySet();
    }

    protected Iterable<TypeFilter> getIncludeFilters() {
        return Collections.emptySet();
    }
}

