/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

public class TraceHandlerFunction
implements HandlerFunction {
    private final HandlerFunction<?> delegate;
    private final BeanFactory beanFactory;
    private CurrentTraceContext currentTraceContext;

    public TraceHandlerFunction(HandlerFunction<?> delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public Mono<?> handle(ServerRequest serverRequest) {
        AtomicReference scope = new AtomicReference();
        return Mono.just(scope).doFirst(() -> serverRequest.attribute(TraceWebFilter.TRACE_REQUEST_ATTR).ifPresent(span -> scope.set(this.currentTraceContext().maybeScope(((Span)span).context())))).flatMap(r -> this.delegate.handle(serverRequest)).doFinally(signalType -> {
            CurrentTraceContext.Scope spanInScope = (CurrentTraceContext.Scope)scope.get();
            if (spanInScope != null) {
                spanInScope.close();
            }
        });
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }
}

