/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

abstract class TomcatResources {
    private final Context context;

    TomcatResources(Context context) {
        this.context = context;
    }

    void addResourceJars(List<URL> resourceJarUrls) {
        for (URL url : resourceJarUrls) {
            String file = url.getFile();
            if (!file.endsWith(".jar") && !file.endsWith(".jar!/")) continue;
            String jar = url.toString();
            if (!jar.startsWith("jar:")) {
                jar = "jar:" + jar + "!/";
            }
            this.addJar(jar);
        }
    }

    protected final Context getContext() {
        return this.context;
    }

    protected abstract void addJar(String var1);

    protected abstract void addDir(String var1, URL var2);

    public static TomcatResources get(Context context) {
        if (ClassUtils.isPresent((String)"org.apache.catalina.deploy.ErrorPage", null)) {
            return new Tomcat7Resources(context);
        }
        return new Tomcat8Resources(context);
    }

    static class Tomcat8Resources
    extends TomcatResources {
        Tomcat8Resources(Context context) {
            super(context);
        }

        @Override
        protected void addJar(String jar) {
            this.addResourceSet(jar);
        }

        @Override
        protected void addDir(String dir, URL url) {
            this.addResourceSet(url.toString());
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.getContext().getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class Tomcat7Resources
    extends TomcatResources {
        private final Method addResourceJarUrlMethod;

        Tomcat7Resources(Context context) {
            super(context);
            this.addResourceJarUrlMethod = ReflectionUtils.findMethod(context.getClass(), (String)"addResourceJarUrl", (Class[])new Class[]{URL.class});
        }

        @Override
        protected void addJar(String jar) {
            URL url = this.getJarUrl(jar);
            if (url != null) {
                try {
                    this.addResourceJarUrlMethod.invoke((Object)this.getContext(), url);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        private URL getJarUrl(String jar) {
            try {
                return new URL(jar);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        @Override
        protected void addDir(String dir, URL url) {
            if (this.getContext() instanceof ServletContext) {
                try {
                    Class<?> fileDirContextClass = Class.forName("org.apache.naming.resources.FileDirContext");
                    Method setDocBaseMethod = ReflectionUtils.findMethod(fileDirContextClass, (String)"setDocBase", (Class[])new Class[]{String.class});
                    Object fileDirContext = fileDirContextClass.newInstance();
                    setDocBaseMethod.invoke(fileDirContext, dir);
                    Method addResourcesDirContextMethod = ReflectionUtils.findMethod(StandardContext.class, (String)"addResourcesDirContext", (Class[])new Class[]{DirContext.class});
                    addResourcesDirContextMethod.invoke((Object)this.getContext(), fileDirContext);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Tomcat 7 reflection failed", ex);
                }
            }
        }
    }
}

