/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.actuate.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

class CompositeHandlerMapping
implements HandlerMapping {
    @Autowired
    private ListableBeanFactory beanFactory;
    private @Nullable List<HandlerMapping> mappings;

    CompositeHandlerMapping() {
    }

    public @Nullable HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        for (HandlerMapping mapping : this.getMappings()) {
            HandlerExecutionChain handler = mapping.getHandler(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public boolean usesPathPatterns() {
        for (HandlerMapping mapping : this.getMappings()) {
            if (!mapping.usesPathPatterns()) continue;
            return true;
        }
        return false;
    }

    private List<HandlerMapping> getMappings() {
        if (this.mappings == null) {
            this.mappings = this.extractMappings();
        }
        return this.mappings;
    }

    private List<HandlerMapping> extractMappings() {
        ArrayList<HandlerMapping> list = new ArrayList<HandlerMapping>(this.beanFactory.getBeansOfType(HandlerMapping.class).values());
        list.remove(this);
        AnnotationAwareOrderComparator.sort(list);
        return list;
    }
}

