/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.tunnel.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.tunnel.server.PortProvider;
import org.springframework.boot.devtools.tunnel.server.RemoteDebugNotRunningException;
import org.springframework.boot.lang.UsesUnsafeJava;
import sun.misc.VMSupport;

public class RemoteDebugPortProvider
implements PortProvider {
    private static final String JDWP_ADDRESS_PROPERTY = "sun.jdwp.listenerAddress";
    private static final Log logger = LogFactory.getLog(RemoteDebugPortProvider.class);

    @Override
    public int getPort() {
        if (!RemoteDebugPortProvider.isRemoteDebugRunning()) {
            throw new RemoteDebugNotRunningException();
        }
        return RemoteDebugPortProvider.getRemoteDebugPort();
    }

    public static boolean isRemoteDebugRunning() {
        return RemoteDebugPortProvider.getRemoteDebugPort() != -1;
    }

    @UsesUnsafeJava
    private static int getRemoteDebugPort() {
        String property = VMSupport.getAgentProperties().getProperty(JDWP_ADDRESS_PROPERTY);
        try {
            if (property != null && property.contains(":")) {
                return Integer.valueOf(property.split(":")[1]);
            }
        }
        catch (Exception ex) {
            logger.trace((Object)("Unable to get JDWP port from property value '" + property + "'"));
        }
        return -1;
    }
}

