/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

final class ApiVersion {
    private static final Pattern PATTERN = Pattern.compile("^v?(\\d+)\\.(\\d*)$");
    private final int major;
    private final int minor;

    private ApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    void assertSupports(ApiVersion other) {
        if (!this.supports(other)) {
            throw new IllegalStateException("Detected platform API version '" + other + "' does not match supported version '" + this + "'");
        }
    }

    boolean supports(ApiVersion other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.major == 0 || this.major != other.major) {
            return false;
        }
        return this.minor >= other.minor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiVersion other = (ApiVersion)obj;
        return this.major == other.major && this.minor == other.minor;
    }

    public int hashCode() {
        return this.major * 31 + this.minor;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor;
    }

    static ApiVersion parse(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        Matcher matcher = PATTERN.matcher(value);
        Assert.isTrue((boolean)matcher.matches(), () -> "Malformed version number '" + value + "'");
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            return new ApiVersion(major, minor);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Malformed version number '" + value + "'", ex);
        }
    }

    static ApiVersion of(int major, int minor) {
        return new ApiVersion(major, minor);
    }
}

