/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.util.Assert;

@Endpoint(id="health")
public class HealthEndpoint {
    private final HealthIndicator healthIndicator;

    public HealthEndpoint(HealthIndicator healthIndicator) {
        Assert.notNull((Object)healthIndicator, (String)"HealthIndicator must not be null");
        this.healthIndicator = healthIndicator;
    }

    @ReadOperation
    public Health health() {
        return this.healthIndicator.health();
    }

    @ReadOperation
    public Health healthForComponent(@Selector String component) {
        HealthIndicator indicator = this.getNestedHealthIndicator(this.healthIndicator, component);
        return indicator != null ? indicator.health() : null;
    }

    @ReadOperation
    public Health healthForComponentInstance(@Selector String component, @Selector String instance) {
        HealthIndicator indicator = this.getNestedHealthIndicator(this.healthIndicator, component);
        HealthIndicator nestedIndicator = this.getNestedHealthIndicator(indicator, instance);
        return nestedIndicator != null ? nestedIndicator.health() : null;
    }

    private HealthIndicator getNestedHealthIndicator(HealthIndicator healthIndicator, String name) {
        if (healthIndicator instanceof CompositeHealthIndicator) {
            return ((CompositeHealthIndicator)healthIndicator).getRegistry().get(name);
        }
        return null;
    }
}

