/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.function.Consumer;
import org.springframework.boot.actuate.metrics.buffer.Buffers;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffer;
import org.springframework.lang.UsesJava8;

@UsesJava8
public class CounterBuffers
extends Buffers<CounterBuffer> {
    public void increment(String name, final long delta) {
        this.doWith(name, new Consumer<CounterBuffer>(){

            @Override
            public void accept(CounterBuffer buffer) {
                buffer.setTimestamp(System.currentTimeMillis());
                buffer.add(delta);
            }
        });
    }

    public void reset(String name) {
        this.doWith(name, new Consumer<CounterBuffer>(){

            @Override
            public void accept(CounterBuffer buffer) {
                buffer.setTimestamp(System.currentTimeMillis());
                buffer.reset();
            }
        });
    }

    @Override
    protected CounterBuffer createBuffer() {
        return new CounterBuffer(0L);
    }
}

