/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.amqp;

import java.util.Map;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.actuate.amqp.RabbitHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RabbitAutoConfiguration.class})
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnBean(value={RabbitTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="rabbit")
public class RabbitHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<RabbitHealthIndicator, RabbitTemplate> {
    public RabbitHealthContributorAutoConfiguration() {
        super(RabbitHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"rabbitHealthIndicator", "rabbitHealthContributor"})
    public HealthContributor rabbitHealthContributor(Map<String, RabbitTemplate> rabbitTemplates) {
        return (HealthContributor)this.createContributor(rabbitTemplates);
    }
}

