/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.lang.reflect.Method;
import org.springframework.batch.item.data.RepositoryItemWriter;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;

public class RepositoryItemWriterBuilder<T> {
    private CrudRepository<T, ?> repository;
    private String methodName;
    private RepositoryMethodReference repositoryMethodReference;

    public RepositoryItemWriterBuilder<T> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RepositoryItemWriterBuilder<T> repository(CrudRepository<T, ?> repository) {
        this.repository = repository;
        return this;
    }

    public RepositoryItemWriterBuilder<T> repository(RepositoryMethodReference repositoryMethodReference) {
        this.repositoryMethodReference = repositoryMethodReference;
        return this;
    }

    public RepositoryItemWriter<T> build() {
        if (this.repositoryMethodReference != null) {
            this.methodName = this.repositoryMethodReference.getMethodName();
            this.repository = this.repositoryMethodReference.getRepository();
        }
        Assert.hasText((String)this.methodName, (String)"methodName is required.");
        Assert.notNull(this.repository, (String)"repository is required.");
        RepositoryItemWriter<T> writer = new RepositoryItemWriter<T>();
        writer.setMethodName(this.methodName);
        writer.setRepository(this.repository);
        return writer;
    }

    private static class RepositoryMethodInterceptor
    implements MethodInterceptor {
        private String methodName;

        private RepositoryMethodInterceptor() {
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            this.methodName = method.getName();
            return null;
        }

        String getMethodName() {
            return this.methodName;
        }
    }

    public static class RepositoryMethodReference<T> {
        private RepositoryMethodInterceptor repositoryInvocationHandler;
        private CrudRepository<?, ?> repository;

        public RepositoryMethodReference(CrudRepository<?, ?> repository) {
            this.repository = repository;
            this.repositoryInvocationHandler = new RepositoryMethodInterceptor();
        }

        public T methodIs() {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(this.repository.getClass());
            enhancer.setCallback((Callback)this.repositoryInvocationHandler);
            return (T)enhancer.create();
        }

        CrudRepository<?, ?> getRepository() {
            return this.repository;
        }

        String getMethodName() {
            return this.repositoryInvocationHandler.getMethodName();
        }
    }
}

