/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Locks", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowLocksDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String resFile;
    String dbName;
    String tableName;
    HashMap<String, String> partSpec;
    boolean isExt;
    boolean isNewLockFormat;
    private static final String table = "showlocks";
    private static final String schema = "tab_name,mode#string:string";
    private static final String newFormatSchema = "lockid,database,table,partition,lock_state,lock_type,transaction_id,last_heartbeat,acquired_at,user,hostname#string:string:string:string:string:string:string:string:string:string:string";

    public String getDatabase() {
        return this.dbName;
    }

    public String getTable() {
        return table;
    }

    public String getSchema() {
        if (this.isNewLockFormat) {
            return newFormatSchema;
        }
        return schema;
    }

    public ShowLocksDesc() {
    }

    public ShowLocksDesc(Path resFile, String dbName, boolean isExt, boolean isNewFormat) {
        this.resFile = resFile.toString();
        this.partSpec = null;
        this.tableName = null;
        this.isExt = isExt;
        this.dbName = dbName;
        this.isNewLockFormat = isNewFormat;
    }

    public ShowLocksDesc(Path resFile, String tableName, HashMap<String, String> partSpec, boolean isExt, boolean isNewFormat) {
        this.resFile = resFile.toString();
        this.partSpec = partSpec;
        this.tableName = tableName;
        this.isExt = isExt;
        this.isNewLockFormat = isNewFormat;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public HashMap<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpecs(HashMap<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }

    public boolean isExt() {
        return this.isExt;
    }

    public void setExt(boolean isExt) {
        this.isExt = isExt;
    }

    public boolean isNewFormat() {
        return this.isNewLockFormat;
    }
}

