/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.command.TimeoutException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class CommandExecutor {
    private static final Logger LOG = Loggers.get(CommandExecutor.class);
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    public static CommandExecutor create() {
        return INSTANCE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(Command command, StreamConsumer stdOut, StreamConsumer stdErr, long timeoutMilliseconds) {
        int n;
        StreamGobbler errorGobbler;
        StreamGobbler outputGobbler;
        Process process;
        ExecutorService executorService;
        block10: {
            executorService = null;
            process = null;
            outputGobbler = null;
            errorGobbler = null;
            try {
                ProcessBuilder builder = new ProcessBuilder(command.toStrings(false));
                if (command.getDirectory() != null) {
                    builder.directory(command.getDirectory());
                }
                builder.environment().putAll(command.getEnvironmentVariables());
                process = builder.start();
                outputGobbler = new StreamGobbler(process.getInputStream(), stdOut);
                errorGobbler = new StreamGobbler(process.getErrorStream(), stdErr);
                outputGobbler.start();
                errorGobbler.start();
                Process finalProcess = process;
                executorService = Executors.newSingleThreadExecutor();
                Future<Integer> ft = executorService.submit(finalProcess::waitFor);
                int exitCode = timeoutMilliseconds < 0L ? ft.get().intValue() : ft.get(timeoutMilliseconds, TimeUnit.MILLISECONDS).intValue();
                CommandExecutor.waitUntilFinish(outputGobbler);
                CommandExecutor.waitUntilFinish(errorGobbler);
                CommandExecutor.verifyGobbler(command, outputGobbler, "stdOut");
                CommandExecutor.verifyGobbler(command, errorGobbler, "stdErr");
                n = exitCode;
                if (process == null) break block10;
            }
            catch (java.util.concurrent.TimeoutException te) {
                try {
                    throw new TimeoutException(command, "Timeout exceeded: " + timeoutMilliseconds + " ms", te);
                    catch (CommandException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new CommandException(command, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        process.destroy();
                    }
                    CommandExecutor.waitUntilFinish(outputGobbler);
                    CommandExecutor.waitUntilFinish(errorGobbler);
                    CommandExecutor.closeStreams(process);
                    if (executorService != null) {
                        executorService.shutdown();
                    }
                    throw throwable;
                }
            }
            process.destroy();
        }
        CommandExecutor.waitUntilFinish(outputGobbler);
        CommandExecutor.waitUntilFinish(errorGobbler);
        CommandExecutor.closeStreams(process);
        if (executorService != null) {
            executorService.shutdown();
        }
        return n;
    }

    private static void verifyGobbler(Command command, StreamGobbler gobbler, String type) {
        if (gobbler.getException() != null) {
            throw new CommandException(command, "Error inside " + type + " stream", gobbler.getException());
        }
    }

    public int execute(Command command, long timeoutMilliseconds) {
        LOG.info("Executing command: " + command);
        return this.execute(command, new DefaultConsumer(), new DefaultConsumer(), timeoutMilliseconds);
    }

    private static void closeStreams(@Nullable Process process) {
        if (process != null) {
            IOUtils.closeQuietly(process.getInputStream());
            IOUtils.closeQuietly(process.getOutputStream());
            IOUtils.closeQuietly(process.getErrorStream());
        }
    }

    private static void waitUntilFinish(@Nullable StreamGobbler thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException while waiting finish of " + thread.toString(), e);
            }
        }
    }

    private static class DefaultConsumer
    implements StreamConsumer {
        private DefaultConsumer() {
        }

        @Override
        public void consumeLine(String line) {
            LOG.info(line);
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final StreamConsumer consumer;
        private volatile Exception exception;

        StreamGobbler(InputStream is, StreamConsumer consumer) {
            super("ProcessStreamGobbler");
            this.is = is;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.consumeLine(line);
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        private void consumeLine(String line) {
            if (this.exception == null) {
                try {
                    this.consumer.consumeLine(line);
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

