/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ExpectedConditions {
    private static final Logger log = Logger.getLogger(ExpectedConditions.class.getName());

    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> titleIs(final String title) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return title.equals(driver.getTitle());
            }

            public String toString() {
                return "title to be: " + title;
            }
        };
    }

    public static ExpectedCondition<Boolean> titleContains(final String title) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String currentTitle = driver.getTitle();
                return currentTitle == null ? false : currentTitle.contains(title);
            }

            public String toString() {
                return "title to contain " + title;
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.findElement(locator, driver);
            }

            public String toString() {
                return "presence of element located by: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                try {
                    return ExpectedConditions.elementIfVisible(ExpectedConditions.findElement(locator, driver));
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return "visibility of element located by " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOf(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.elementIfVisible(element);
            }

            public String toString() {
                return "visibility of " + element;
            }
        };
    }

    private static WebElement elementIfVisible(WebElement element) {
        return element.isDisplayed() ? element : null;
    }

    public static ExpectedCondition<List<WebElement>> presenceOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                return ExpectedConditions.findElements(locator, driver);
            }

            public String toString() {
                return "presence of any elements located by " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElement(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver from) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, from).getText();
                    return elementText.contains(text);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be present in element found by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver from) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, from).getAttribute("value");
                    if (elementText != null) {
                        return elementText.contains(text);
                    }
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be the value of element located by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final String frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver from) {
                try {
                    return from.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + frameLocator;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return !ExpectedConditions.findElement(locator, driver).isDisplayed();
                }
                catch (NoSuchElementException e) {
                    return true;
                }
                catch (StaleElementReferenceException e) {
                    return true;
                }
            }

            public String toString() {
                return "element to no longer be visible: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final By locator) {
        return new ExpectedCondition<WebElement>(){
            public ExpectedCondition<WebElement> visibilityOfElementLocated;
            {
                this.visibilityOfElementLocated = ExpectedConditions.visibilityOfElementLocated(locator);
            }

            public WebElement apply(WebDriver driver) {
                WebElement element = (WebElement)this.visibilityOfElementLocated.apply(driver);
                try {
                    if (element != null && element.isEnabled()) {
                        return element;
                    }
                    return null;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return "element to be clickable: " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> stalenessOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver ignored) {
                try {
                    element.isEnabled();
                    return false;
                }
                catch (StaleElementReferenceException expected) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element (%s) to become stale", element);
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(WebElement element) {
        return ExpectedConditions.elementSelectionStateToBe(element, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final WebElement element, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver from) {
                return element.isSelected() == selected;
            }

            public String toString() {
                return String.format("element (%s) to %sbe selected", element, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(By locator) {
        return ExpectedConditions.elementSelectionStateToBe(locator, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final By locator, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver from) {
                try {
                    WebElement element = from.findElement(locator);
                    return element.isSelected() == selected;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("element found by %s to %sbe selected", locator, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Alert> alertIsPresent() {
        return new ExpectedCondition<Alert>(){

            public Alert apply(WebDriver input) {
                try {
                    return input.switchTo().alert();
                }
                catch (NoAlertPresentException e) {
                    return null;
                }
            }

            public String toString() {
                return "alert to be present";
            }
        };
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }

    private static List<WebElement> findElements(By by, WebDriver driver) {
        try {
            return driver.findElements(by);
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

