/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.WebDriverException;

class HttpMessage {
    private final Multimap<String, String> headers = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newLinkedList);
    private final Map<String, Object> attributes = Maps.newHashMap();
    private InputStream content = new ByteArrayInputStream(new byte[0]);
    private volatile byte[] readContent = null;

    HttpMessage() {
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Iterable<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Iterable<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    public String getHeader(String name) {
        return this.headers.entries().stream().filter(e -> Objects.nonNull(e.getKey())).filter(e -> ((String)e.getKey()).equalsIgnoreCase(name.toLowerCase())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.headers.put((Object)name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    public void removeHeader(String name) {
        this.headers.removeAll((Object)name);
    }

    public Charset getContentEncoding() {
        Charset charset = StandardCharsets.UTF_8;
        try {
            String contentType = this.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse((String)contentType);
                charset = (Charset)mediaType.charset().or((Object)StandardCharsets.UTF_8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return charset;
    }

    public void setContent(byte[] data) {
        this.content = new ByteArrayInputStream(data);
    }

    public void setContent(InputStream toStreamFrom) {
        this.content = toStreamFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() {
        if (this.readContent == null) {
            HttpMessage httpMessage = this;
            synchronized (httpMessage) {
                if (this.readContent == null) {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        ByteStreams.copy((InputStream)this.consumeContentStream(), (OutputStream)bos);
                        this.readContent = bos.toByteArray();
                    }
                    catch (IOException e) {
                        throw new WebDriverException((Throwable)e);
                    }
                }
            }
        }
        return this.readContent;
    }

    public String getContentString() {
        return new String(this.getContent(), this.getContentEncoding());
    }

    public InputStream consumeContentStream() {
        return this.content;
    }
}

