/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_EXE_PROPERTY = "webdriver.ie.driver";

    private InternetExplorerDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static InternetExplorerDriverService createDefaultService() {
        return new Builder().usingAnyFreePort().build();
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;
        private InternetExplorerDriverLogLevel logLevel;

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            InternetExplorerDriverService.checkExecutable((File)file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withLogLevel(InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public InternetExplorerDriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = InternetExplorerDriverService.findExecutable((String)"IEDriverServer", (String)InternetExplorerDriverService.IE_DRIVER_EXE_PROPERTY, (String)"http://code.google.com/p/selenium/wiki/InternetExplorerDriver", (String)"http://code.google.com/p/selenium/downloads/list");
            }
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add((Object)String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add((Object)String.format("--log-file=%s", this.logFile.getAbsolutePath()));
                }
                if (this.logLevel != null) {
                    argsBuilder.add((Object)String.format("--log-level=%s", this.logLevel.toString()));
                }
                return new InternetExplorerDriverService(this.exe, this.port, argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

