/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.InternetExplorerDriverServer;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS = "ignoreProtectedModeSettings";
    private InternetExplorerDriverServer server;
    private WindowsProxyManager proxyManager;

    public InternetExplorerDriver() {
        this.assertOnWindows();
        this.setup((Capabilities)DesiredCapabilities.internetExplorer(), 0);
    }

    public InternetExplorerDriver(Capabilities capabilities) {
        this.assertOnWindows();
        this.proxyManager = new WindowsProxyManager(true, "webdriver-ie", 0, 0);
        this.prepareProxy(capabilities);
        this.setup(capabilities, 0);
    }

    public InternetExplorerDriver(int port) {
        this.assertOnWindows();
        this.setup((Capabilities)DesiredCapabilities.internetExplorer(), port);
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", current));
        }
    }

    private void setup(Capabilities capabilities, int port) {
        this.server = new InternetExplorerDriverServer(port);
        this.startClient();
        this.setCommandExecutor((CommandExecutor)new HttpCommandExecutor(this.server.getUrl()));
        this.setElementConverter(new JsonToWebElementConverter(this){

            protected RemoteWebElement newRemoteWebElement() {
                return new InternetExplorerElement(InternetExplorerDriver.this);
            }
        });
        this.startSession(capabilities);
    }

    protected void startClient() {
        this.server.start();
    }

    protected void stopClient() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null) {
            return;
        }
        this.proxyManager.backupRegistrySettings();
        this.proxyManager.changeRegistrySettings(caps);
        Thread cleanupThread = new Thread(){

            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }
}

