/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import org.openqa.selenium.Alert;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.android.library.AlertManager;

public class AndroidAlert
implements Alert {
    private final String message;
    private final JsResult result;
    private String textToSend = null;
    private final String defaultValue;

    AndroidAlert(String message, JsResult result) {
        this(message, result, null);
    }

    AndroidAlert(String message, JsResult result, String defaultValue) {
        this.message = message;
        this.result = result;
        this.defaultValue = defaultValue;
    }

    public void accept() {
        AlertManager.removeAlert(this);
        if (this.isPrompt()) {
            JsPromptResult promptResult = (JsPromptResult)this.result;
            String result = this.textToSend == null ? this.defaultValue : this.textToSend;
            promptResult.confirm(result);
        } else {
            this.result.confirm();
        }
    }

    private boolean isPrompt() {
        return this.result instanceof JsPromptResult;
    }

    public void dismiss() {
        AlertManager.removeAlert(this);
        this.result.cancel();
    }

    public String getText() {
        return this.message;
    }

    public void sendKeys(String keys) {
        if (!this.isPrompt()) {
            throw new ElementNotVisibleException("Alert did not have text field");
        }
        this.textToSend = (this.textToSend == null ? "" : this.textToSend) + keys;
    }
}

