/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UIDataScroller;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.renderkit.ControlsState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf-uncompressed.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="script/datascroller.js"), @ResourceDependency(name="css/datascroller.ecss")})
public class DataScrollerBaseRenderer
extends RendererBase {
    public void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String param = (String)paramMap.get((clientId = component.getClientId(context)) + ":page");
        if (param != null) {
            UIDataScroller scroller = (UIDataScroller)component;
            int newPage = scroller.getPageForFacet(param);
            int page = scroller.getPage();
            if (newPage != 0 && newPage != page) {
                new DataScrollerEvent((UIComponent)scroller, String.valueOf(page), param, newPage).queue();
            }
        }
    }

    public ControlsState getControlsState(FacesContext context, UIComponent component) {
        int fastStep = (Integer)component.getAttributes().get("fastStep");
        int pageIndex = (Integer)component.getAttributes().get("page");
        int pageCount = (Integer)component.getAttributes().get("pageCount");
        int minPageIdx = 1;
        int maxPageIdx = pageCount;
        if (fastStep <= 1) {
            fastStep = 1;
        }
        boolean useFirst = true;
        boolean useLast = true;
        boolean useBackFast = true;
        boolean useForwFast = true;
        ControlsState controlsState = new ControlsState();
        if (pageIndex <= minPageIdx) {
            useFirst = false;
        }
        if (pageIndex >= maxPageIdx) {
            useLast = false;
        }
        if (pageIndex - fastStep < minPageIdx) {
            useBackFast = false;
        }
        if (pageIndex + fastStep > maxPageIdx) {
            useForwFast = false;
        }
        String boundaryControls = (String)component.getAttributes().get("boundaryControls");
        String fastControls = (String)component.getAttributes().get("fastControls");
        boolean isAuto = "auto".equals(boundaryControls);
        if (isAuto || "show".equals(boundaryControls)) {
            if (isAuto) {
                controlsState.setFirstRendered(useFirst);
                controlsState.setLastRendered(useLast);
            }
            controlsState.setFirstEnabled(useFirst);
            controlsState.setLastEnabled(useLast);
        } else {
            controlsState.setFirstRendered(false);
            controlsState.setLastRendered(false);
        }
        isAuto = "auto".equals(fastControls);
        if (isAuto || "show".equals(fastControls)) {
            if (isAuto) {
                controlsState.setFastForwardRendered(useForwFast);
                controlsState.setFastRewindRendered(useBackFast);
            }
            controlsState.setFastForwardEnabled(useForwFast);
            controlsState.setFastRewindEnabled(useBackFast);
        } else {
            controlsState.setFastForwardRendered(false);
            controlsState.setFastRewindRendered(false);
        }
        UIComponent controlsSeparatorFacet = component.getFacet("controlsSeparator");
        if (controlsSeparatorFacet != null && controlsSeparatorFacet.isRendered()) {
            controlsState.setControlsSeparatorRendered(true);
        }
        return controlsState;
    }

    public Map<String, String> renderPager(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        int start;
        int pages;
        int currentPage = (Integer)component.getAttributes().get("page");
        int maxPages = (Integer)component.getAttributes().get("maxPages");
        int pageCount = (Integer)component.getAttributes().get("pageCount");
        HashMap<String, String> digital = new HashMap<String, String>();
        if (pageCount <= 1) {
            return digital;
        }
        if (maxPages <= 1) {
            maxPages = 1;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && currentPage > delta) {
            pages = maxPages;
            start = currentPage - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        String clientId = component.getClientId(context);
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String style;
            String styleClass;
            boolean isCurrentPage;
            boolean bl = isCurrentPage = i + 1 == currentPage;
            if (isCurrentPage) {
                styleClass = (String)component.getAttributes().get("selectedStyleClass");
                style = (String)component.getAttributes().get("selectedStyle");
            } else {
                styleClass = (String)component.getAttributes().get("inactiveStyleClass");
                style = (String)component.getAttributes().get("inactiveStyle");
            }
            if (styleClass == null) {
                styleClass = "";
            }
            if (isCurrentPage) {
                out.startElement("span", component);
                out.writeAttribute("class", (Object)("rf-ds-dtl rf-ds-cur " + styleClass), null);
            } else {
                out.startElement("a", component);
                out.writeAttribute("class", (Object)("rf-ds-dtl " + styleClass), null);
                out.writeAttribute("href", (Object)"javascript:void(0);", null);
            }
            if (null != style) {
                out.writeAttribute("style", (Object)style, null);
            }
            String page = Integer.toString(i + 1);
            String id = clientId + "_ds_" + page;
            out.writeAttribute("id", (Object)id, null);
            digital.put(id, page);
            out.writeText((Object)page, null);
            if (isCurrentPage) {
                out.endElement("span");
                continue;
            }
            out.endElement("a");
        }
        return digital;
    }

    public Map<String, Map<String, String>> getControls(FacesContext context, UIComponent component, ControlsState controlsState) {
        HashMap<String, Map<String, String>> controls = new HashMap<String, Map<String, String>>();
        HashMap<String, String> right = new HashMap<String, String>();
        HashMap<String, String> left = new HashMap<String, String>();
        String clientId = component.getClientId(context);
        if (controlsState.getFirstRendered() && controlsState.getFirstEnabled()) {
            left.put(clientId + "_ds_f", "first");
        }
        if (controlsState.getFastRewindRendered() && controlsState.getFastRewindEnabled()) {
            left.put(clientId + "_ds_fr", "fastrewind");
        }
        if (controlsState.getFastForwardRendered() && controlsState.getFastForwardEnabled()) {
            right.put(clientId + "_ds_ff", "fastforward");
        }
        if (controlsState.getLastRendered() && controlsState.getLastEnabled()) {
            right.put(clientId + "_ds_l", "last");
        }
        if (!left.isEmpty()) {
            controls.put("left", left);
        }
        if (!right.isEmpty()) {
            controls.put("right", right);
        }
        return controls;
    }

    public void buildScript(ResponseWriter writer, FacesContext context, UIComponent component, Map buttons, Map digitals) throws IOException {
        JSFunction function = new JSFunction("new RichFaces.ui.DataScroller", new Object[0]);
        function.addParameter((Object)component.getClientId(context));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("buttons", buttons);
        options.put("digitals", digitals);
        options.put("currentPage", (Integer)component.getAttributes().get("page"));
        function.addParameter((Object)this.getSubmitFunction(context, component));
        function.addParameter(options);
        writer.write(function.toString());
    }

    public JSFunctionDefinition getSubmitFunction(FacesContext facesContext, UIComponent component) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[]{JSReference.EVENT, new JSReference("element"), new JSReference("data")});
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((FacesContext)facesContext, (UIComponent)component, (String)"RichFaces.ajax");
        AjaxEventOptions options = AjaxRendererUtils.buildEventOptions((FacesContext)facesContext, (UIComponent)component);
        Map parameters = options.getParameters();
        parameters.put(component.getClientId(facesContext) + ":page", new JSLiteral("data.page"));
        function.addParameter((Object)options);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        definition.addToBody((Object)buffer);
        return definition;
    }

    public boolean getRendersChildren() {
        return true;
    }
}

