/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.richfaces.component.Column;
import org.richfaces.component.Expandable;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.event.ToggleEvent;
import org.richfaces.event.ToggleListener;

@ResourceDependency(name="subtable.js")
public class UISubTable
extends UIDataTableBase
implements Column,
Expandable {
    public static final String MODE_AJAX = "ajax";
    public static final String MODE_SERVER = "server";
    public static final String MODE_CLIENT = "client";
    public static final int EXPAND_STATE = 1;
    public static final int COLLAPSE_STATE = 0;

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ToggleEvent) {
            ToggleEvent toggleEvent = (ToggleEvent)event;
            boolean newValue = toggleEvent.isExpanded();
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)newValue);
            FacesContext facesContext = this.getFacesContext();
            ELContext elContext = facesContext.getELContext();
            ValueExpression valueExpression = this.getValueExpression(PropertyKeys.expanded.toString());
            if (valueExpression != null && !valueExpression.isReadOnly(elContext)) {
                valueExpression.setValue(elContext, (Object)newValue);
            }
            if (this.getFacesContext().getPartialViewContext().isAjaxRequest()) {
                String render = this.resolveClientId(facesContext, (UIComponent)this, "body");
                this.getFacesContext().getPartialViewContext().getRenderIds().add(render);
                String togglerId = toggleEvent.getTogglerId();
                if (togglerId != null) {
                    this.getFacesContext().getPartialViewContext().getRenderIds().add(togglerId);
                }
            }
        }
        super.broadcast(event);
    }

    public boolean isExpanded() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expanded), (Object)true);
    }

    public void setExpanded(boolean expanded) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)expanded);
    }

    public boolean isBreakBefore() {
        return true;
    }

    public void setBreakBefore(boolean newBreakBefore) {
        throw new IllegalStateException("Property 'breakBefore' for subtable is read-only");
    }

    public String getSortExpression() {
        return null;
    }

    public void setSortExpression(String sortExpression) {
        throw new IllegalArgumentException("subtable is not sortable element");
    }

    public void addToggleListener(ToggleListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeToggleListener(ToggleListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public ToggleListener[] getToggleListeners() {
        return (ToggleListener[])this.getFacesListeners(ToggleListener.class);
    }

    public String getExpandMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expandMode), (Object)MODE_CLIENT);
    }

    public void setExpandMode(String expandMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expandMode), (Object)expandMode);
    }

    public void setIterationState(Object stateObject) {
        Object[] state = (Object[])stateObject;
        if (state != null) {
            super.setIterationState(state[0]);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), state[1]);
        } else {
            super.setIterationState(null);
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), null);
        }
    }

    public Object getIterationState() {
        Object[] state = new Object[]{super.getIterationState(), this.getStateHelper().get((Serializable)((Object)PropertyKeys.expanded))};
        return state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        expandMode,
        expanded,
        toggleExpression;

    }
}

