/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.powermock.api.extension.listener.MockMetadata;
import org.powermock.reflect.Whitebox;

public class AnnotationMockMetadata
implements MockMetadata {
    private final Class<?> type;
    private final Method[] methods;
    private final String qualifier;
    private final Class<? extends Annotation> annotation;
    private final Annotation annotationInstance;
    private final String fieldName;
    private Object mock;

    public AnnotationMockMetadata(Class<? extends Annotation> annotation, Field field) throws Exception {
        this.annotation = annotation;
        this.annotationInstance = field.getAnnotation(annotation);
        this.type = field.getType();
        this.fieldName = field.getName();
        this.methods = this.getMethod();
        this.qualifier = this.findQualifier();
    }

    private String findQualifier() {
        String fieldName = "";
        try {
            fieldName = (String)Whitebox.invokeMethod((Object)this.annotationInstance, (String)"fieldName", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fieldName.length() == 0) {
            return "";
        }
        return fieldName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Method[] getMethods() {
        return this.methods;
    }

    private Method[] getMethod() throws Exception {
        String[] value = (String[])Whitebox.invokeMethod((Object)this.annotationInstance, (String)"value", (Object[])new Object[0]);
        if (value.length != 1 || !"".equals(value[0])) {
            return Whitebox.getMethods(this.type, (String[])value);
        }
        return null;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public void setMock(Object mock) {
        this.mock = mock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationMockMetadata that = (AnnotationMockMetadata)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return Arrays.equals(this.methods, that.methods) && (this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.methods);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }
}

