package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class ChildAxis extends Axis {
    public ChildAxis() {}

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                  throws XPathException {
        return new ChildAxisIterator(contextNode, navigator);
    }

    /**
     * The principal node type of this axis is
     * {@link Navigator#ELEMENT}.
     **/
    public int getPrincipalNodeType() {
        return Navigator.ELEMENT;
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "child";
    }

    class ChildAxisIterator implements AxisIterator {
        private Object contextNode;
        private Navigator navigator;
        private int count;
        private int current = 0;

        ChildAxisIterator(Object contextNode, Navigator navigator)
                                         throws XPathException {
            this.contextNode = contextNode;
            this.navigator = navigator;
            count = navigator.childCount(contextNode);
        }

        public boolean hasNext() {
            return current < count;
        }

        public Object next() throws XPathException {
            if (current >= count) throw new XPathException(
                            "No more elements in iterator");
            return navigator.getChild(contextNode, current++);
        }
    }
}
