package org.planx.xpath.expr;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.object.*;

/**
 * Represents a path expression composed of a FilterExpression
 * and a relative LocationPath.
 **/
public class PathExpression extends Expression {
    private final Expression expr;
    private final LocationPath locationPath;

    public PathExpression(Expression expr, LocationPath locationPath) {
        this.expr = expr;
        this.locationPath = locationPath;
    }

    public XObject evaluate(Context ctxt, Environment env, Navigator nav)
                                                   throws XPathException {
        try {
            XNodeSet set = (XNodeSet) expr.evaluate(ctxt, env, nav);
            return locationPath.evaluate(set, env, nav);
        } catch (ClassCastException e) {
            throw new XPathException("Expression did not evaluate "+
                                     "to an XNodeSet: "+expr);
        }
    }

    public String toString() {
        return expr.toString()+"/"+locationPath.toString();
    }
}
