package org.planx.xpath.expr;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

/**
 * Represents a node test.
 **/
public abstract class NodeTest {
    /**
     * Returns <code>true</code> if the specified object matches
     * this node test. The argument <code>principalNodeType</code>
     * is the principal node type of the axis as specified in
     * {@link Navigator}.
     **/
    public abstract boolean matches(Object node, int principalNodeType,
                            Navigator navigator) throws XPathException;
}
