package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.concurrent.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.references.*;
import org.planx.xmlstore.util.Concurrency;

/**
 * Optimistically writes without blocking returning a proxy <code>Reference</code>
 * that is resolved when the save process is completed. If the <code>Reference</code>
 * is used before that, the thread will block until the reference is resolved.
 *
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 * @author Thomas Ambus
 */
public class OptimisticWriteXMLStore extends AbstractXMLStore {

    public OptimisticWriteXMLStore(XMLStore xmlstore) {
        super(xmlstore);
    }

    public Reference save(final Node n) {
        checkClosed();
        Callable<Reference> callable = new Callable<Reference>() {
            public Reference call() throws IOException {
                return xmlstore.save(n);
            }
        };
        Future<Reference> future = Concurrency.localExecutor().submit(callable);
        return new ReferenceProxy(future);
    }
}
