package org.planx.xmlstore.nodes;

import org.planx.xmlstore.Node;
import org.planx.xmlstore.io.LocalLocator;

/**
 * @author Thomas Ambus
 */
public interface LocatorListener {
    /**
     * Informs that a <code>LocalLocator</code> has been loaded.
     * Since the FileSystemIdentifier might not have been persisted it may
     * be wrong, so this is an opportunity for a listener to correct it
     * to the correct fsi.
     */
    public LocalLocator locatorLoaded(LocalLocator target,
                                      LocalLocator parent, int childIndex);

    /**
     * Informs that a <code>Node</code> with the specified <code>LocalLocator</code>
     * has been loaded.
     */
    public void nodeLoaded(LocalLocator loc, SystemNode node, boolean hasOutgoing);

    /**
     * Informs that a <code>Node</code> with the specified <code>LocalLocator</code>
     * has been saved.
     */
    public void nodeSaved(LocalLocator loc, SystemNode node, boolean hasOutgoing);

    /**
     * Requests a lookup of a <code>Node</code> with the specified <code>LocalLocator</code>.
     * Can return <code>null</code> to indicate that it is unknown, in which case
     * the <code>Node</code> will just be loaded.
     */
    public SystemNode lookup(LocalLocator loc);
}
