package org.planx.xmlstore.convert;

import java.util.List;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.xml.sax.*;
import org.xml.sax.ext.*;
import org.xml.sax.helpers.*;

/* Based on the JDOM SAXOutputter */

/**
 * @author Henning Niss
 */
public class SAXOutputter {

    private ContentHandler content_handler;
    private ErrorHandler error_handler;
    private DTDHandler dtd_handler;
    private EntityResolver entity_resolver;
    private LexicalHandler lexical_handler;
    private DeclHandler decl_handler;

    public SAXOutputter(ContentHandler content) {
        this(content, null, null, null, null);
    }

    public SAXOutputter(ContentHandler content,
                        ErrorHandler   error,
                        DTDHandler     dtd,
                        EntityResolver entity) {
        this(content, error, dtd, entity, null);
    }

    public SAXOutputter(ContentHandler content,
                        ErrorHandler   error,
                        DTDHandler     dtd,
                        EntityResolver entity,
                        LexicalHandler lexical) {
        this.content_handler = content;
        this.error_handler = error;
        this.dtd_handler = dtd;
        this.entity_resolver = entity;
        this.lexical_handler = lexical;

    }

    public void output(Node root) throws XMLException {
        startDocument();
        recurse(root);
        endDocument();
    }

    private void recurse(Node n) throws XMLException {
        switch(n.getType()) {
        case Node.ELEMENT:
            String tag = n.getNodeValue();

            AttributesImpl attr = new AttributesImpl();
            List<Attribute> attrs = n.getAttributes();
            for (Attribute a : attrs) {
                /* FIXME: what about namespaces? */
                attr.addAttribute("",a.getName(),a.getName(),
                                  "CDATA" /* FIXME; see XML 3.3.3 */,
                                  a.getValue());
            }

            startElement(tag,attr);
            List<? extends Node> children = n.getChildren();
            n = null;
            for (Node c : children) {
                recurse(c);
            }
            endElement(tag);
            break;

        case Node.CHARDATA:
            characters(n.getNodeValue());
            break;

        default:
            throw new XMLException("recurse: unknown node type");
        }
    }

    private void startDocument() throws XMLException {
        try { content_handler.startDocument(); }
        catch (SAXException e) {
            throw new XMLException("SAX(startDocument): " + e);
        }
    }
    private void endDocument() throws XMLException {
        try { content_handler.endDocument(); }
        catch (SAXException e) {
            throw new XMLException("SAX(endDocument): " + e);
        }
    }

    private void startElement(String tag, Attributes attr) throws XMLException {
        /* FIXME: what about namespaces? */
        try { content_handler.startElement("", tag, tag, attr); }
        catch (SAXException e) {
            throw new XMLException("SAX(startElement): " + e);
        }
    }
    private void endElement(String tag) throws XMLException {
        try { content_handler.endElement("", tag, tag); }
        catch (SAXException e) {
            throw new XMLException("SAX(endElement): " + e);
        }
    }

    private void characters(String ch) throws XMLException {
        try { content_handler.characters(ch.toCharArray(), 0, ch.length()); }
        catch (SAXException e) {
            throw new XMLException("SAX(characters): " + e);
        }
    }
}
