package org.planx.xmlstore.convert;

import java.io.*;
import javax.xml.parsers.*;
import org.planx.xmlstore.*;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 */
public class DVMBuilder {
    private static SAXParser parser;
    private XMLStore xmlstore = null;

    static {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            parser = factory.newSAXParser();
        } catch (ParserConfigurationException e) {

        } catch (SAXException e) {

        }
    }

    public DVMBuilder(XMLStore xmlstore) {
        this.xmlstore = xmlstore;
    }

    /**
     * Reads an XML document in serialized form and builds a DVM
     * representation of the document. The return value is the root node of
     * the DVM representation. The DVM document consists of immutable nodes
     * and is not saved.
     *
     * @param  in serialized XML document.
     * @return  root node of the DVM representation.
     */
    public static Node parse(InputSource in) throws XMLException, IOException {
        org.w3c.dom.Document doc = DOMUtil.parseSource(in);
        org.w3c.dom.Node root = doc.getDocumentElement();
        root = DOMUtil.removeEmptyTextNodes(root);
        return DOMBuilder.build(root);
    }

    /**
     * Reads an XML document in serialized form and builds a DVM
     * representation of the document. The return value is the root node of
     * the DVM representation. The DVM document consists of immutable nodes
     * and is not saved.
     *
     * @param  fileName file name denoting the serialized XML document.
     * @return  root node of the DVM representation.
     */
    public static Node parse(String fileName) throws XMLException, IOException {
        org.w3c.dom.Document doc = DOMUtil.parseFile(fileName);
        org.w3c.dom.Node root = doc.getDocumentElement();
        root = DOMUtil.removeEmptyTextNodes(root);
        return DOMBuilder.build(root);
    }

    /**
     * Unparses an XML document in serialized format to a persistent
     * representation in the Document Value Model (DVM). The DVM document
     * consists of immutable nodes and is saved during unparsing. A
     * reference to the document's root node is returned.
     *
     * @param  in serialized XML document
     * @return  value reference to the root node of the DVM representation .
     */
    public Reference unparse(InputSource in) throws XMLException, IOException {
        Node node = SAXBuilder.build(in, xmlstore);
        return xmlstore.save(node);
    }

    /**
     * Unparses an XML document in serialized format to a persistent
     * representation in the Document Value Model (DVM). The DVM document
     * consists of immutable nodes and is saved during unparsing. A
     * reference to the document's root node is returned.
     *
     * @param  fileName serialized XML document
     * @return  value reference to the root node of the DVM representation .
     */
    public Reference unparse(String fileName) throws XMLException, IOException {
        Node node = SAXBuilder.build(fileName, xmlstore);
        return xmlstore.save(node);
    }

    public static Node saxparse(String fileName) throws XMLException, IOException {
        return SAXBuilder.build(fileName);
    }
}
