package org.planx.util;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

/**
 * @author Thomas Ambus
 */
public class UnmodifiableArrayList<E> extends AbstractList<E>
                implements RandomAccess, java.io.Serializable {
    private E[] a;

    public UnmodifiableArrayList(List<E> list) {
        this((E[]) list.toArray());
    }

    public UnmodifiableArrayList(E[] array) {
        if (array==null) throw new NullPointerException();
        a = array;
    }

    public E[] internal() {
        return a;
    }

    public int size() {
        return a.length;
    }

    public E get(int index) {
        return (E) a[index];
    }

    public int indexOf(Object o) {
        if (o==null) {
            for (int i=0; i<a.length; i++)
                if (a[i]==null)
                    return i;
        } else {
            for (int i=0; i<a.length; i++)
                if (o.equals(a[i]))
                    return i;
        }
        return -1;
    }

    public boolean contains(Object o) {
        return indexOf(o) != -1;
    }

    public Object[] toArray() {
        Object[] result = new Object[a.length];
        System.arraycopy(a, 0, result, 0, a.length);
        return result;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length < a.length)
            array = (T[])java.lang.reflect.Array.
                newInstance(array.getClass().getComponentType(), a.length);
        System.arraycopy(a, 0, array, 0, a.length);
        if (array.length > a.length) array[a.length] = null;
        return array;
    }
}
