package org.planx.msd.lang;

/**
 * Represents a discriminable reference to an object.
 *
 * @author Thomas Ambus
 */
public class Reference<T> implements EquivalenceClassDiscriminable {
    private T obj;
    private EquivalenceClass eqCls;

    /**
     * Creates a new discriminable reference belonging to its own
     * <code>EquivalenceClass</code>. Other references can later by
     * added to this <code>EquivalenceClass</code> by using the
     * <code>Reference(Object, EquivalenceClass)</code> constructor
     * and getting this reference's <code>EquivalenceClass</code>
     * using the <code>getEquivalenceClass</code> method.
     */
    public Reference(T obj) {
        this(obj, null);
    }

    /**
     * Creates a new discriminable reference belonging to the specified
     * <code>EquivalenceClass</code>. If <code>eqCls</code> is <code>null</code>
     * a new <code>EquivalenceClass</code> will be created and this
     * <code>Reference</code> will be the only member. Other references can
     * later be added to this <code>EquivalenceClass</code>.
     */
    public Reference(T obj, EquivalenceClass eqCls) {
        this.obj = obj;
        this.eqCls = (eqCls == null) ? new EquivalenceClass() : eqCls;
    }

    /**
     * Returns the <code>Object</code> pointed to by this <code>Reference</code>.
     */
    public T get() {
        return obj;
    }

    public EquivalenceClass getEquivalenceClass() {
        return eqCls;
    }

    public void setEquivalenceClass(EquivalenceClass eqCls) {
        this.eqCls = eqCls;
    }

    /**
     * Returns <code>true</code> if and only if the specified object is also
     * an <code>EquivalenceClassDiscriminable</code> and that
     * <code>EquivalenceClassDiscriminable</code> points to the
     * same <code>EquivalenceClass</code> object as this <code>Reference</code>.
     */
    public boolean equals(Object o) {
        if (o != null && o instanceof EquivalenceClassDiscriminable)
            return eqCls == ((EquivalenceClassDiscriminable) o).getEquivalenceClass();
        return false;
    }

    /**
     * Returns the result of invoking <code>hashCode</code> on the
     * <code>EquivalenceClass</code> of this <code>Reference</code>. The reason
     * for this is that if two objects are equal according to the
     * <code>equals(Object)</code> method, then calling the <code>hashCode</code>
     * method on each of the two objects must produce the same integer result.
     */
    public int hashCode() {
        return eqCls.hashCode();
    }

    /**
     * Returns the result of invoking the <code>toString</code> method on the
     * object pointed to by this <code>Reference</code>.
     */
    public String toString() {
        return (obj == null) ? "null" : obj.toString();
    }
}
