/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class AttributeAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new AttributeAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 4;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "attribute";
    }

    class AttributeAxisIterator
    implements AxisIterator {
        private Object contextNode;
        private Navigator navigator;
        private int count;
        private int current = 0;

        AttributeAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.contextNode = contextNode;
            this.navigator = navigator;
            this.count = navigator.attributeCount(contextNode);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.count;
        }

        @Override
        public Object next() throws XPathException {
            if (this.current >= this.count) {
                throw new XPathException("No more elements in iterator");
            }
            return this.navigator.getAttribute(this.contextNode, this.current++);
        }
    }
}

