/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.references;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Memory;
import org.planx.msd.array.ByteArrayDiscriminator;
import org.planx.msd.util.DiscriminatorAdapter;
import org.planx.util.Array;
import org.planx.util.Converter;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.references.ReferenceListener;
import org.planx.xmlstore.references.ValueReference;
import org.planx.xmlstore.routing.Identifier;

public class ContentValueReference
implements ValueReference,
Serializable,
Comparable<ContentValueReference> {
    public static final byte CLASS_ID = 2;
    private static final int LENGTH = 16;
    private byte[] contentHash;
    private transient int hash = 0;

    public ContentValueReference(Node node) {
        this.contentHash = ContentValueReference.reference((Node)node, null).contentHash;
    }

    ContentValueReference(byte[] contentHash) {
        if (contentHash.length != 16) {
            throw new IllegalArgumentException("Invalid content hash length");
        }
        this.contentHash = contentHash;
    }

    public static ContentValueReference reference(Node node, ReferenceListener listener) {
        SystemNode n;
        if (node instanceof SystemNode && (n = (SystemNode)node).getReference() instanceof ContentValueReference) {
            return (ContentValueReference)n.getReference();
        }
        return ContentValueReference.computeMD5(node, listener);
    }

    private static ContentValueReference computeMD5(Node node, ReferenceListener listener) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return ContentValueReference.computeMD5(node, md, listener);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static ContentValueReference computeMD5(Node node, MessageDigest mdFactory, ReferenceListener listener) throws CloneNotSupportedException {
        ContentValueReference vref;
        if (listener != null && (vref = listener.lookup(node)) != null) {
            return vref;
        }
        MessageDigest md = (MessageDigest)mdFactory.clone();
        md.reset();
        md.update(node.getNodeValue().getBytes());
        if (node.getType() == 0) {
            List<Attribute> attributes = node.getAttributes();
            Object[] attrs = new Attribute[attributes.size()];
            attrs = attributes.toArray(attrs);
            Arrays.sort(attrs);
            for (int i = 0; i < attrs.length; ++i) {
                md.update(attrs[i].getName().getBytes());
                md.update(attrs[i].getValue().getBytes());
            }
            List<? extends Node> children = node.getChildren();
            for (Node node2 : children) {
                ContentValueReference vref2 = ContentValueReference.computeMD5(node2, mdFactory, listener);
                md.update(vref2.contentHash);
            }
        }
        ContentValueReference ref = new ContentValueReference(md.digest());
        if (listener != null) {
            listener.referenceComputed(node, ref);
        }
        return ref;
    }

    @Override
    public Identifier asIdentifier() {
        return new Identifier(this.contentHash);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentValueReference)) {
            return false;
        }
        ContentValueReference vref = (ContentValueReference)o;
        return Arrays.equals(this.contentHash, vref.contentHash);
    }

    @Override
    public int compareTo(ContentValueReference vref) {
        if (vref == null) {
            throw new NullPointerException();
        }
        return Array.compareTo(this.contentHash, vref.contentHash);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.contentHash);
        }
        return this.hash;
    }

    public String toString() {
        return Converter.toHex(this.contentHash);
    }

    public static Streamer<ContentValueReference> getStreamer() {
        return new Streamer<ContentValueReference>(){

            @Override
            public void toStream(DataOutput out, ContentValueReference vref) throws IOException {
                out.write(vref.contentHash);
            }

            @Override
            public ContentValueReference fromStream(DataInput in) throws IOException {
                byte[] id = new byte[16];
                in.readFully(id);
                return new ContentValueReference(id);
            }
        };
    }

    public static Discriminator<ContentValueReference> getDiscriminator() {
        return ContentValueReference.getDiscriminator(DiscriminatorFactory.instance().getMemory());
    }

    public static Discriminator<ContentValueReference> getDiscriminator(Memory memory) {
        return new DiscriminatorAdapter<ContentValueReference, byte[]>((Discriminator)new ByteArrayDiscriminator(memory)){

            @Override
            protected byte[] transform(ContentValueReference vref) {
                return vref.contentHash;
            }
        };
    }
}

