package org.planx.xmlstore.nodes;

import java.util.List;
import org.planx.msd.lang.EquivalenceClassDiscriminable;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;

public interface SystemNode extends Node, EquivalenceClassDiscriminable {
    /**
     * Resolves the node if it is a proxy and guarantees to return a 'real' node.
     */
    public SystemNode get();
    public boolean isShared();
    public void setShared(boolean isShared);
    public int getHeight();
    public void setHeight(int height);
    public void setChild(int index, SystemNode child);
    public Reference getReference();
    public void setReference(Reference ref);
    public LocalLocator getLocator();
    public void setLocator(LocalLocator loc);
    public Object getVisitToken();
    public void setVisitToken(Object token);
    public List<SystemNode> getChildren();
}
